-- 

USE BD_Air_France;

-- ajout d'un groupe de fichier pour le stockage des flux LOBs

ALTER DATABASE BD_Air_France
      ADD FILEGROUP FG_Stream CONTAINS FILESTREAM;

-- ajout d'un fichier dans ce nouveau groupe
-- im faut que C:\temp\sql-server existe 

ALTER DATABASE BD_Air_France
ADD FILE
   (NAME     = F_STREAM,
    FILENAME = 'C:\temp\sql-server\streams') 
TO FILEGROUP FG_Stream;

-- se remettre dans le contexte de la base

use BD_Air_France;

CREATE TABLE T_Films_flm
( flm_id          INT IDENTITY PRIMARY KEY,
  flm_stream_GUID UNIQUEIDENTIFIER ROWGUIDCOL UNIQUE NOT NULL, 
  flm_titre       VARCHAR(256),
  flm_video       VARBINARY(MAX) FILESTREAM)
FILESTREAM_ON FG_Stream;
  
-- insertion de donnes de test dans le fileStream (50 sec pour 250 Mo...)

DECLARE @film VARBINARY(MAX);
SELECT @film = 
 CAST(bulkcolumn AS VARBINARY(MAX))
 FROM OPENROWSET(BULK 'C:\temp\top_gun.wmv', SINGLE_BLOB) AS navet;
INSERT INTO T_Films_flm
       (flm_titre, flm_stream_GUID, flm_video)
VALUES ('Top Gun', NEWID(), @film);

-- vrification :

SELECT *, flm_video.PathName()
FROM   T_Films_flm;

DROP TABLE T_Films_flm;